
<div class="rts-event-section-content">
<ul class="list-unstyled rts-counter">

<?php 

if ( is_plugin_active('the-events-calendar/the-events-calendar.php') ) { 
	foreach ( $events as $event ) {
	    // Ensure the $event is set up as the current post
	    setup_postdata($event);
	    
	    // Fetch terms for the event for use in classes
	    $terms = get_the_terms($event->ID, 'tribe_events_cat');
	    $termsString = !empty($terms) && !is_wp_error($terms) ? join(' ', wp_list_pluck($terms, 'slug')) : '';
	    ?>
		<div class="col-lg-<?php echo esc_html($settings['portfolio_columns']);?> col-md-6 col-xs-1 grid-item <?php echo $termsString;?>">
			<li class="single-event event_item">
				<div class="single-event-counter">
					<div class="count-number rt-clip-text"></div>
				</div>
				<div class="single-event-content">				
					<h5 class="event-title">                    
						<?php 
							$length = !empty($settings['title_word_count']) ? $settings['title_word_count'] : 6;
						?>
						<a aria-label="event title" href="<?php echo get_permalink($event->ID); ?>"><?php echo wp_trim_words(get_the_title($event->ID), $length, ''); ?></a>
					</h5>
					<div class="single-event-content-meta">
						<?php
							$date = tribe_get_start_date($event);
							$location = tribe_get_address($event);
							if(!empty($date)) : ?>
								<div class="date">
									<span><svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
														<path d="M0.527387 13.8008H3.1641V15.3828C3.1641 15.674 3.40021 15.9101 3.69144 15.9101H17.4727C17.7639 15.9101 18 15.674 18 15.3828V1.67187C18 1.38064 17.7639 1.14453 17.4727 1.14453H14.836V0.617186C14.836 0.325953 14.5998 0.0898438 14.3086 0.0898438C14.0174 0.0898438 13.7813 0.325953 13.7813 0.617186V1.14453H11.1094V0.617186C11.1094 0.325953 10.8733 0.0898438 10.5821 0.0898438C10.2908 0.0898438 10.0547 0.325953 10.0547 0.617186V1.14453H7.418V0.617186C7.418 0.325953 7.18189 0.0898438 6.89066 0.0898438C6.59942 0.0898438 6.36331 0.325953 6.36331 0.617186V1.14453H3.69144C3.40021 1.14453 3.1641 1.38064 3.1641 1.67187V4.83593C3.1641 8.72244 1.54885 11.7123 0.189782 12.8683C0.0192041 13.0104 -0.0440419 13.2442 0.0315088 13.453C0.10713 13.6617 0.30534 13.8008 0.527387 13.8008ZM16.9453 14.8554H4.21879V13.8008H14.3086C14.432 13.8008 14.5514 13.7575 14.6462 13.6785C15.2802 13.1505 16.2621 11.8934 16.9453 10.2833V14.8554ZM4.21879 2.19921H6.36331V2.72656C6.36331 3.01779 6.59942 3.2539 6.89066 3.2539C7.18189 3.2539 7.418 3.01779 7.418 2.72656V2.19921H10.0547V2.72656C10.0547 3.01779 10.2908 3.2539 10.5821 3.2539C10.8733 3.2539 11.1094 3.01779 11.1094 2.72656V2.19921H13.7813V2.72656C13.7813 3.01779 14.0174 3.2539 14.3086 3.2539C14.5998 3.2539 14.836 3.01779 14.836 2.72656V2.19921H16.9453V4.30859H4.21879V2.19921ZM4.20975 5.36292H16.936C16.8171 8.70821 15.5332 11.3403 14.1018 12.7461H1.72688C3.34874 10.6796 4.12274 7.98881 4.20975 5.36292Z" fill="#262626"/>
													</svg></span>
									<span><?php echo tribe_get_start_date($event, false, 'F j, Y'); ?></span>
								</div>
								<?php 
							endif; ?>					
							
							<div class="time">
								<span>
									<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path fill-rule="evenodd" clip-rule="evenodd" d="M5.13876 17.2754C6.57769 18.2368 8.26942 18.75 10 18.75C12.3206 18.75 14.5462 17.8281 16.1872 16.1872C17.8281 14.5462 18.75 12.3206 18.75 10C18.75 8.26942 18.2368 6.57769 17.2754 5.13876C16.3139 3.69983 14.9473 2.57832 13.3485 1.91606C11.7496 1.25379 9.9903 1.08051 8.29296 1.41813C6.59563 1.75575 5.03653 2.58911 3.81282 3.81282C2.58911 5.03653 1.75575 6.59563 1.41813 8.29296C1.08051 9.9903 1.25379 11.7496 1.91606 13.3485C2.57832 14.9473 3.69983 16.3139 5.13876 17.2754ZM5.83323 3.76398C7.0666 2.93987 8.51664 2.5 10 2.5C11.9891 2.5 13.8968 3.29018 15.3033 4.6967C16.7098 6.10323 17.5 8.01088 17.5 10C17.5 11.4834 17.0601 12.9334 16.236 14.1668C15.4119 15.4001 14.2406 16.3614 12.8701 16.9291C11.4997 17.4968 9.99168 17.6453 8.53683 17.3559C7.08197 17.0665 5.7456 16.3522 4.6967 15.3033C3.64781 14.2544 2.9335 12.918 2.64411 11.4632C2.35473 10.0083 2.50325 8.50032 3.07091 7.12988C3.63856 5.75943 4.59986 4.58809 5.83323 3.76398ZM9.375 10.2563L12.8688 13.75L13.75 12.8687L10.625 9.7375V4.375H9.375V10.2563Z" fill="white"/>
									</svg>
								</span>
								<span><?php echo get_the_time(); ?></span>
							</div>
							
							<?php
								$venues = $this->get_venue_data($event);
								$has_location = false;
								$location_output = '';
								// Iterate through the venues and check if any have a non-empty address
								foreach ($venues as $venue) {
									if (!empty($venue['address'])) {
										$has_location = true;
										$location_output .= $venue['address'] . '<br>'; // Append each location with a line break
									}
								}
								// Only display the HTML if there is at least one non-empty location
								if ($has_location): ?>
									<div class="location">
										<svg width="14" height="18" viewBox="0 0 14 18" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path fill-rule="evenodd" clip-rule="evenodd" d="M1.72782 11.5321L7.00001 17.75L12.2744 11.5295C12.3023 11.4964 12.4898 11.2499 12.4898 11.2499L12.4908 11.2483C13.391 10.0624 13.8773 8.61389 13.875 7.125C13.875 5.30164 13.1507 3.55295 11.8614 2.26364C10.5721 0.974328 8.82337 0.25 7.00001 0.25C5.17664 0.25 3.42796 0.974328 2.13865 2.26364C0.849335 3.55295 0.125007 5.30164 0.125007 7.125C0.122896 8.6145 0.609508 10.0636 1.51019 11.2499C1.51019 11.2499 1.69788 11.4964 1.72782 11.5321ZM2.5379 10.5364C2.52003 10.5128 2.508 10.497 2.50782 10.4969C1.77156 9.52708 1.37362 8.34261 1.37501 7.125C1.37501 5.63316 1.96764 4.20242 3.02253 3.14752C4.07742 2.09263 5.50816 1.5 7.00001 1.5C8.49185 1.5 9.92259 2.09263 10.9775 3.14752C12.0324 4.20242 12.625 5.63316 12.625 7.125C12.6264 8.34195 12.2288 9.5258 11.493 10.4951C11.4927 10.4956 11.3462 10.6892 11.3188 10.7237L7.00001 15.8174L2.68694 10.7309C2.66321 10.7013 2.58243 10.595 2.5379 10.5364ZM5.26384 9.72334C5.77775 10.0667 6.38194 10.25 7 10.25C7.82851 10.2491 8.62282 9.91952 9.20867 9.33367C9.79452 8.74782 10.1241 7.95351 10.125 7.125C10.125 6.50694 9.94172 5.90275 9.59834 5.38884C9.25496 4.87494 8.76691 4.4744 8.19589 4.23788C7.62487 4.00135 6.99654 3.93947 6.39034 4.06005C5.78415 4.18063 5.22733 4.47825 4.79029 4.91529C4.35325 5.35233 4.05563 5.90915 3.93505 6.51534C3.81447 7.12154 3.87635 7.74987 4.11288 8.32089C4.3494 8.89191 4.74994 9.37996 5.26384 9.72334ZM5.95831 5.566C6.26665 5.35997 6.62916 5.25 7 5.25C7.49712 5.25055 7.97371 5.44827 8.32522 5.79978C8.67674 6.15129 8.87446 6.62789 8.875 7.125C8.875 7.49584 8.76504 7.85835 8.55901 8.1667C8.35298 8.47504 8.06014 8.71536 7.71753 8.85728C7.37492 8.99919 6.99792 9.03632 6.63421 8.96397C6.27049 8.89163 5.9364 8.71305 5.67418 8.45083C5.41195 8.1886 5.23338 7.85451 5.16103 7.4908C5.08868 7.12708 5.12581 6.75008 5.26773 6.40747C5.40964 6.06486 5.64997 5.77202 5.95831 5.566Z" fill="#262626"/>
										</svg>
										<span><?php echo $location_output; ?></span>
									</div>
								<?php 
								endif; 
							?>
					</div>
				</div>
			</li>
		</div>

	    <?php
	}
}
// Reset post data
wp_reset_postdata();
?>
</ul>
</div>